import cv2
import os
from tqdm import tqdm


def images_to_video(image_folder, output_video, fps=30):
    """
    Converts a folder of images into a video file.

    :param image_folder: Path to the folder containing images
    :param output_video: Path for the output video file
    :param fps: Frames per second for the output video
    """
    # Get all image files from the folder
    images = [img for img in os.listdir(image_folder) if img.endswith((".png", ".jpg", ".jpeg"))]

    if not images:
        print("No images found in the folder.")
        return

    # Sort images by name to maintain sequence
    images.sort(key=lambda x: int(os.path.splitext(x)[0]))

    # print(images)

    # Define the codec and create a VideoWriter object
    width, height = 640, 480     # Resize dimensions
    fourcc = cv2.VideoWriter_fourcc(*'mp4v')     # Codec for .mp4 files
    video = cv2.VideoWriter(output_video, fourcc, fps, (width, height))

    # Write each image to the video
    for image in images:
        image_path = os.path.join(image_folder, image)
        frame = cv2.imread(image_path)
        frame = cv2.resize(frame, (width, height))     # Resize the image
        video.write(frame)

    # Release the video writer
    video.release()
    # print(f"Video saved as {output_video}")


# Example usage
if __name__ == "__main__":
    image_folder = "/data2/datasets/scannet/color"     # Replace with your image folder path
    output_video = "/data2/datasets/scannet/video_10"     # Replace with your desired output video file name
    fps = 3     # Frames per second

    for scene in tqdm(os.listdir(image_folder)):
        # print(scene)
        scene_path = os.path.join(image_folder, scene)
        if os.path.isdir(scene_path):
            images_to_video(scene_path, f"{output_video}/{scene}.mp4", fps)

        # break

    # images_to_video(image_folder, output_video, fps)
